% ALPHA ENGINE DEFINITION
% Generated 29-Jun-2023 11:06:49

% SUGGESTED CITATION:
% GT Power 2020 GM 3.0L Duramax Engine from Argonne Report Diesel Fuel - ALPHA Map Package. Version 2023-06. Ann Arbor MI: US EPA National Vehicle and Fuel Emissions Laboratory, National Center for Advanced Technology, 2023.


% Constructor
engine = class_REVS_engine();
engine.name =  'GT Power 2020 GM 3.0L Duramax Engine from Argonne Report Diesel Fuel'; 
engine.source_filename = mfilename;
engine.matrix_vintage = enum_matrix_vintage.present;

% Physical Description
engine.displacement_L =  3; 
engine.num_cylinders =  6; 
engine.combustion_type = enum_engine_combustion_type.compression_ignition;
engine.bore_mm =  84; 
engine.stroke_mm =  90; 

% Maximum Torque Curve
engine.full_throttle_speed_radps = [	     0.0000000000000000	;     68.067840827778852	;     104.71975511965977	;     130.89969389957471	;     157.07963267948966	;     261.79938779914943	;     314.15926535897933	;     366.51914291880917	;     418.87902047863906	;     471.23889803846896	;     494.80084294039244	;     518.36278784231592		]; 
engine.full_throttle_torque_Nm = [	     0.0000000000000000	;     100.00000000000000	;     332.70990000000000	;     600.49554000000001	;     620.20569999999998	;     622.04236000000003	;     619.40890000000002	;     580.57870000000003	;     496.74759999999998	;     372.43554999999998	;     316.49512749999991	;     0.0000000000000000		]; 
engine.naturally_aspirated_speed_radps = [	     0.0000000000000000	;     518.36278784231592		]; 
engine.naturally_aspirated_torque_Nm = [	     214.85917317405870	    214.85917317405870		]; 

% Minimum Torque Curve
engine.closed_throttle_speed_radps = [	     0.0000000000000000	;     73.303828583761842	;     261.79938779914943	;     418.87902047863906	;     518.36278784231592		]; 
engine.closed_throttle_torque_Nm = [	    -13.753939393939396	;    -21.000000000000000	;    -34.399999999999999	;    -55.159999999999997	;    -64.993939393939399		]; 

% Fuel Map
engine.fuel_map_speed_radps = [	     0.0000000000000000	;     26.179938779914941	;     52.359877559829883	;     78.539816339744817	;     104.71975511965977	;     130.89969389957471	;     157.07963267948969	;     183.25957145940455	;     209.43951023931953	;     235.61944901923454	;     261.79938779914943	;     287.97932657906438	;     314.15926535897938	;     340.33920413889422	;     366.51914291880911	;     392.69908169872417	;     418.87902047863906	;     445.05895925855401	;     471.23889803846896	;     494.80084294039244	;     518.36278784231592		]; 
engine.fuel_map_torque_Nm = [	    -68.243636363636369	;    -33.892448575620058	;    0.45873921239624882	;     23.893092229337718	;     47.731181799760272	;     71.939066917656874	;     95.258884885813842	;     119.34510328164735	;     143.03336635097116	;     166.59049807295057	;     190.90805642926534	;     214.76514382154559	;     238.48875069361134	;     261.78183874429578	;     286.69639430545953	;     310.30004463216676	;     333.90369495887393	;     357.74898431655652	;     381.59427367423916	;     405.05305508319310	;     428.51183649214704	;     452.79210876514173	;     477.07238103813643	;     497.98335510249638	;     525.86644278065114	;     565.85247150635723	;     592.33579819998943	;     618.81912489362162	;     653.14447800000005		]; 
engine.fuel_map_gps = [
 -0.038074473019999562	  -0.12061658760098412	  -0.20306660995658055	  -0.26136350928262947	  -0.30449585542556495	  -0.34635073645540815	  -0.38660135890602820	  -0.42420443599991869	  -0.45725984425160499	  -0.48351315264102313	  -0.50138960185605297	  -0.50736380644097723	  -0.49871252187016019	  -0.47215949472759455	  -0.42322709665823227	  -0.35398174916432884	  -0.26766631706980132	  -0.17543047306661463	 -0.083591245154227431	-0.0014814311982338079	  0.079595977678295238	;
 -0.027368058463971997	 -0.063653153580021438	 -0.099912368959501549	  -0.11119927716512355	  -0.11736963760073746	  -0.12350054401567578	  -0.13086481631442856	  -0.13658807739408513	  -0.13526944891334589	  -0.12261812285004903	 -0.093620849923312280	 -0.051798631707022584	-0.0014792045647445606	  0.057809875157738652	   0.13266938999388728	   0.24876021482397395	   0.37746881193388254	   0.52260646297993707	   0.68123624697848817	   0.81357800756260745	   0.94137637697479970	;
 -0.016811533343641185	-0.0067494972330714555	 0.0078381041457056874	  0.039237397358318694	  0.069528810614845088	  0.098183482901723379	   0.12347713764495491	   0.15045160976962890	   0.18782718105366297	   0.23510206508334930	   0.31545346771654981	   0.40286646497839196	   0.49379875319849392	   0.59843034980407495	   0.69048065745263720	   0.86437131043017967	    1.0147383216322445	    1.2108093276281613	    1.4469627995101346	    1.6247297441300168	    1.8057178857985752	;
-0.0097748887267624235	  0.032002956889529387	  0.084755853483404933	   0.14242732613809542	   0.19759310194507326	   0.24503283563379788	   0.29505205893545833	   0.34792129854966153	   0.40978494101388180	   0.48275701375118846	   0.59641753037100287	   0.70910237248278030	   0.82497568986768532	   0.96255012218902147	    1.1155006169397887	    1.2728780096394070	    1.4471916613464137	    1.6891816890548750	    1.9437659484445438	    2.1746479162544565	    2.4032826315669165	;
-0.0027599906052707432	  0.077179182121031351	   0.16322050433917465	   0.24794249090084597	   0.32911284686042241	   0.40504815166386426	   0.48459847499331182	   0.56585160000757706	   0.65178437641366327	   0.75531390442447122	   0.89915237053139940	    1.0353366501835073	    1.1810063414128980	    1.3446300751576004	    1.5387996523807812	    1.7230562267498308	    1.9389448889939489	    2.2163583795525210	    2.4777647502288032	    2.7519006312663326	    3.0178376383364474	;
  0.014020744805609381	   0.12904575963473841	   0.24363919330549866	   0.35724783473012850	   0.47002783088770822	   0.58579718535370895	   0.70043700466708658	   0.81166110985539308	   0.92125784898084706	    1.0639198022213314	    1.2293926621512721	    1.3865413383098442	    1.5706769850016475	    1.7749672829653131	    2.0247164653247696	    2.2690134047089554	    2.5302522547456925	    2.8137154838496441	    3.1011410311011920	    3.3748061238620628	    3.6516798757691982	;
  0.035996598563866569	   0.17954076225505369	   0.32275107552805443	   0.46588020224740673	   0.61116665219516297	   0.76242992299575629	   0.90524860200021595	    1.0483608462193470	    1.1985487260109253	    1.3657294530445230	    1.5571841655439422	    1.7583551830757456	    1.9667935006541009	    2.2763990353944203	    2.5726439722389411	    2.8526847272886018	    3.1457064544310529	    3.4135349864962903	    3.7255371378276108	    3.9975201842950612	    4.2787343659344383	;
  0.058550902630019858	   0.23272705749383374	   0.40682916054538976	   0.58145474649978124	   0.75816246219501304	   0.93814836183502226	    1.1092286237432245	    1.2818959009421769	    1.4700711412740053	    1.6755676057307114	    1.9238495904443857	    2.1806949667479261	    2.4132128797362067	    2.7265921006402802	    3.0533646519758908	    3.3769278092251391	    3.6963442148079895	    4.0123121892056144	    4.3494611342828557	    4.6482199184981638	    4.9487087140589097	;
  0.080984295236690790	   0.28634334064989797	   0.49182477460135804	   0.69782740096048335	   0.90500490536926537	    1.1136464279811369	    1.3128291110330030	    1.5198381522370430	    1.7471474977673154	    1.9871969916527701	    2.2691660044915221	    2.5602613860043317	    2.8262575161866157	    3.1535244544720999	    3.5074109743830562	    3.8612776520213554	    4.2053682649889863	    4.5805515883230052	    4.9591621009668998	    5.2947160550772754	    5.6301086494849848	;
   0.10394342760150185	   0.34095725314617686	   0.57818913632870950	   0.81568952292355201	    1.0529370061877372	    1.2902323373172733	    1.5186309872217030	    1.7591953443233104	    2.0193040543287619	    2.2943864612947875	    2.5988491849243331	    2.9248906857323127	    3.2286321161207607	    3.5939490917054391	    3.9716472014225443	    4.3384452495658854	    4.7266846462913392	    5.1444193876541995	    5.5657592392116619	    5.9473263634162610	    6.3288547153146570	;
   0.12871263267977079	   0.39862287957855902	   0.66876711658429755	   0.93923102597461428	    1.2096620233638669	    1.4798899991589061	    1.7365641046265956	    2.0075786732610594	    2.2992558474476468	    2.6061308748494354	    2.9493080740163302	    3.3137990633472150	    3.6520663178239063	    4.0489512914230312	    4.4536683446211578	    4.8269340543411241	    5.2794985757447233	    5.7382157721883065	    6.2040081696554834	    6.6373205808394768	    7.0718345671077527	;
   0.15437864049116376	   0.45645737265025116	   0.75873417248183650	    1.0615754123862255	    1.3652132329293674	    1.6687938073339839	    1.9524811870713890	    2.2525866112357305	    2.5753787165812536	    2.9204270759962334	    3.2981936381360302	    3.7010538044663579	    4.0784445640137763	    4.4988482825536469	    4.9231163049324245	    5.3330888818862148	    5.8325987172726643	    6.3358636921732554	    6.8543826313203224	    7.3353389462447192	    7.8215795774198433	;
   0.18142757747792587	   0.51522833006921720	   0.84913608477171187	    1.1835896041239795	    1.5194696630648181	    1.8554817835261497	    2.1689550029643057	    2.4984422535312900	    2.8514584091084600	    3.2329409318028364	    3.6619873634077535	    4.0898488201122039	    4.5038353823665398	    4.9337378205779183	    5.3796966334345999	    5.8480146728088460	    6.3860857972539806	    6.9445855231533935	    7.5180872231546774	    8.0487033775254790	    8.5859866523801891	;
   0.20957067591578057	   0.57411599359965360	   0.93871812680501943	    1.3033983989659401	    1.6686081149573855	    2.0363979912346597	    2.3828027389038198	    2.7453762719831181	    3.1289611263475585	    3.5448337527908218	    4.0227778405234984	    4.4863730124774603	    4.9267138474791512	    5.3594968673442756	    5.8336823344152533	    6.3710632179712112	    6.9521212748882286	    7.5591383597140878	    8.1847402589357117	    8.7652013494510026	    9.3504353376804072	;
   0.24154719197382193	   0.63827533011314452	    1.0351977333208007	    1.4320492123111792	    1.8281636417279521	    2.2272158508470206	    2.6132181282426421	    3.0155725934715769	    3.4319050734344687	    3.8823511038361227	    4.3978761047028545	    4.9270168929264244	    5.4030225533254246	    5.8389097810908721	    6.3427236552989319	    6.9379478837583530	    7.5729442579460091	    8.2355782222571250	    8.9163827129961568	    9.5472432037049195	    10.175140698843149	;
   0.27371133925953933	   0.70003599530009364	    1.1267938082828446	    1.5542706049536923	    1.9814603572578511	    2.4053508738755318	    2.8326036370238925	    3.2688208774283405	    3.7173450044432275	    4.2030315319980005	    4.7446462360581627	    5.3167483641297180	    5.8264940356340276	    6.2975402870319783	    6.8479067960182425	    7.4685504629452319	    8.1554289354438048	    8.8907534209201149	    9.6369078623665843	    10.296940871775865	    10.951437668334016	;
   0.30763949566529480	   0.76275572468801089	    1.2183214334557517	    1.6751111948885256	    2.1331562038611760	    2.5823005707091125	    3.0492350191993371	    3.5219355386319040	    3.9990609548640723	    4.5130649144715678	    5.0744887966364516	    5.6922050686840393	    6.2300249423289999	    6.7470464729929223	    7.3590578989935720	    8.0143514646476941	    8.7494305000598942	    9.5509528405491722	    10.355789202948225	    11.037105776841097	    11.714065377097667	;
   0.34354840556169186	   0.82718563696421998	    1.3109383902807894	    1.7947850536332373	    2.2779724638427030	    2.7610377149887562	    3.2622424955710132	    3.7720413880432400	    4.2798259713727029	    4.8191608225003675	    5.4064163522332738	    6.0295163992810208	    6.5953539514576738	    7.1886045009268393	    7.8631424997727173	    8.5992773601111772	    9.3862346599078563	    10.209650383749782	    11.040424663525789	    11.756462550403514	    12.464569282198022	;
   0.38076717867095899	   0.89266280415066934	    1.4042169225713577	    1.9148653694540618	    2.4245950155253704	    2.9376818969871450	    3.4704360070152975	    4.0163109109865633	    4.5462128813029405	    5.1074962467767895	    5.7147622051205369	    6.3634333225395583	    6.9587175506323486	    7.6251939580098913	    8.3703648498982570	    9.1836000762895669	    10.012417843690061	    10.843757839533216	    11.695060567031460	    12.445333160439334	    13.191345102898426	;
   0.41827892957941298	   0.95811173098105218	    1.4973828375965494	    2.0356646130878215	    2.5740995122559402	    3.1176062036627550	    3.6734638857911701	    4.2377939796387816	    4.7896594246015018	    5.3733105309706843	    6.0002606792011139	    6.6625926550813928	    7.3447173999580828	    8.0842687080389091	    8.8850655970760091	    9.7292364080715217	    10.574371414445189	    11.434366747799132	    12.311121360703916	    13.098775120153682	    13.884317571177343	;
   0.45643364341981613	    1.0246745477604957	    1.5924647793212898	    2.1597661188083523	    2.7279140817153649	    3.2995723204142555	    3.8761399132520564	    4.4621090934604428	    5.0335664362647847	    5.6375478764092648	    6.2898986224644435	    6.9888591859507212	    7.7485730826012738	    8.5565503011777171	    9.4007658353406374	    10.261310843965090	    11.107199222106876	    12.003350457120527	    12.913979331365280	    13.736527127446051	    14.558837423148882	;
   0.49657074278900420	    1.0948156752957345	    1.6929120087056000	    2.2910486744868850	    2.8899134918996419	    3.4900917918792347	    4.0919421931741775	    4.7012548121239588	    5.3066827014011606	    5.9347267165570861	    6.6191243856396342	    7.3742736889988132	    8.1875959425766585	    9.0497964978530163	    9.9293447410674780	    10.792390214007693	    11.664647850944675	    12.588675201269686	    13.532588729059016	    14.386860763818763	    15.241867108728384	;
   0.53751387534967410	    1.1661374973938485	    1.7948887235129709	    2.4239719497382382	    3.0533730360708757	    3.6824893477809297	    4.3101679788201084	    4.9499527024341461	    5.5890556213662492	    6.2440872605211464	    6.9645136002539605	    7.7801548953748396	    8.6348511734361644	    9.5427358332665708	    10.453429178569881	    11.327241048071976	    12.229627700278531	    13.181123031968548	    14.152477906429050	    15.032715797813514	    15.914401933880299	;
   0.57352411151601546	    1.2282585430740074	    1.8832738260355870	    2.5387403563861217	    3.1942368786346029	    3.8484076364389077	    4.5000322298891247	    5.1630150889149649	    5.8279095159694210	    6.5124430518661578	    7.2712679909705962	    8.1224187042989247	    9.0228328985778941	    9.9648862844303938	    10.884032543851349	    11.793501947318882	    12.729832105724178	    13.699343135639097	    14.689768416264284	    15.588501863317218	    16.489278398944414	;
   0.62285028232800921	    1.3118964638736177	    2.0013080114202175	    2.6912155427284028	    3.3810845081698879	    4.0692617016745602	    4.7504040944507251	    5.4492439700171440	    6.1476815226603900	    6.8637225748408159	    7.6765283045235098	    8.5779732064212233	    9.5346876923717563	    10.538006672209692	    11.456445732322614	    12.419163769277205	    13.401786735399838	    14.399521145097514	    15.412216893975454	    16.331231274654606	    17.252877823371673	;
   0.69733732924610448	    1.4332081138818473	    2.1694112899263249	    2.9059860087436657	    3.6419682628565253	    4.3754486254904181	    5.1083866534947697	    5.8515352316779650	    6.5933677985172441	    7.3647079306704661	    8.2598904954296568	    9.2227495292988060	    10.269813918308095	    11.330378629335685	    12.341896580868568	    13.354886634918907	    14.380783132489578	    15.416486576404267	    16.460128729141555	    17.403746052299748	    18.349060216079469	;
   0.74866105664267024	    1.5139601371685381	    2.2794022345246709	    3.0451622011696839	    3.8113568232290134	    4.5775580005601189	    5.3391537874265458	    6.1059599051277909	    6.8842016438640581	    7.7170029225513987	    8.6537125897250533	    9.6738973317916255	    10.765497510804881	    11.860891033502664	    12.925019169794354	    13.978553229840301	    15.034040424834046	    16.094225720233243	    17.158362096173732	    18.118173125903372	    19.078808015609638	;
   0.80089207134185658	    1.5949428797863483	    2.3888601466064596	    3.1826809317366931	    3.9768215073690021	    4.7713377169684357	    5.5629917314951491	    6.3600913703781545	    7.1799929998276273	    8.0649806011119338	    9.0574686661466632	    10.123633193626427	    11.266966720230810	    12.400235481409775	    13.505631788424999	    14.599505577103836	    15.687605900467632	    16.773366359356860	    17.858274160256805	    18.834497036801540	    19.810703018331893	;
   0.86939016971651517	    1.7002226522722885	    2.5304260987249449	    3.3591224217339235	    4.1856721084479380	    5.0108480114521985	    5.8398294554471821	    6.6869461545812916	    7.5789143594108177	    8.5444359464849615	    9.5984126007828241	    10.725404092397790	    11.899801678750832	    13.081180757286527	    14.249872255050256	    15.400427996370084	    16.533917787344631	    17.654475677982497	    18.766849986075869	    19.764643376570124	    20.761377089410171	]; 

% Fuel Properties
engine.fuel = class_REVS_fuel('MTE_DIESEL');

% Idle Speed
engine.idle_target_speed_radps = class_REVS_dynamic_lookup;
engine.idle_target_speed_radps.axis_1.signal =  'eng_runtime_sec'; 
engine.idle_target_speed_radps.axis_1.breakpoints = [	     0.0000000000000000	    10.000000000000000		]; 
engine.idle_target_speed_radps.table = [	     73.303828583761842	    73.303828583761842		]; 

% Calibration Adjustment Factors
engine.variant =  'basic engine'; 
